<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
require_once __DIR__.'/db.php';

function current_user() {
    return $_SESSION['user'] ?? null;
}

function require_login() {
    if (!current_user()) {
        header('Location: ' . BASE_URL . 'index.php?auth=1'); exit;
    }
}

function require_admin() {
    if (!current_user() || current_user()['role'] !== 'admin') {
        http_response_code(403); echo 'Acesso negado'; exit;
    }
}

function login_user($email, $password) {
    $pdo = get_pdo();
    $st = $pdo->prepare("SELECT id,email,password_hash,role,display_name,affiliate_code,default_commission_pct,is_active 
                         FROM users WHERE email = ? LIMIT 1");
    $st->execute([$email]);
    $u = $st->fetch();
    if ($u && intval($u['is_active']) === 1 && password_verify($password, $u['password_hash'])) {
        $_SESSION['user'] = [
            'id' => $u['id'],
            'email' => $u['email'],
            'role' => $u['role'],
            'display_name' => $u['display_name'],
            'affiliate_code' => $u['affiliate_code'],
            'default_commission_pct' => $u['default_commission_pct'],
        ];
        return true;
    }
    return false;
}

function logout_user() {
    $_SESSION = []; session_destroy();
}
?>
