<?php
require_once __DIR__ . '/../app/config.php';
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/csrf.php';

if (session_status() === PHP_SESSION_NONE) { session_start(); }
$pdo = get_pdo();
$msg=null;$err=null;

// Verifica se já tem admin
$hasAdmin = $pdo->query("SELECT COUNT(*) AS c FROM users WHERE role='admin'")->fetch()['c'] ?? 0;

if ($_SERVER['REQUEST_METHOD']==='POST') {
    if (!csrf_check($_POST['csrf'] ?? '')) {
        $err = 'Token inválido.';
    } else {
        if ($hasAdmin) {
            $err = 'Já existe um admin. Apague este arquivo install.php.';
        } else {
            $email = trim($_POST['email'] ?? '');
            $name = trim($_POST['display_name'] ?? '');
            $pass = trim($_POST['password'] ?? '');
            if ($email==='' || $name==='' || $pass==='') $err='Preencha todos os campos.';
            else {
                $hash = password_hash($pass, PASSWORD_DEFAULT);
                $st = $pdo->prepare("INSERT INTO users (email,password_hash,role,display_name,affiliate_code,default_commission_pct,is_active) 
                                     VALUES (?,?,?,?,?,?,?)");
                $st->execute([$email,$hash,'admin',$name,'ADMIN',0,1]);
                $msg='Admin criado. Agora apague o arquivo install.php por segurança.';
            }
        }
    }
}
?>
<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8"/>
<meta name="viewport" content="width=device-width, initial-scale=1"/>
<title>Instalação - <?php echo APP_NAME; ?></title>
<link rel="stylesheet" href="<?php echo BASE_URL; ?>../assets/style.css"/>
</head>
<body>
<div class="container">
  <div class="card">
    <h1>Instalação — Admin</h1>
    <?php if ($msg): ?><div class="alert alert-success"><?php echo htmlspecialchars($msg); ?></div><?php endif; ?>
    <?php if ($err): ?><div class="alert alert-error"><?php echo htmlspecialchars($err); ?></div><?php endif; ?>
    <?php if (!$hasAdmin): ?>
    <form method="post">
      <input type="hidden" name="csrf" value="<?php echo csrf_token(); ?>"/>
      <label>Nome</label><input name="display_name" required/>
      <label>E-mail</label><input type="email" name="email" required/>
      <label>Senha</label><input type="password" name="password" required/>
      <div style="margin-top:12px"><button class="btn btn-primary">Criar Admin</button></div>
    </form>
    <?php else: ?>
      <p>Já existe um admin cadastrado. Apague este arquivo <code>install/install.php</code>.</p>
    <?php endif; ?>
  </div>
</div>
</body>
</html>
