<?php
require_once __DIR__ . '/../../app/config.php';
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/db.php';
require_once __DIR__ . '/../../app/csrf.php';
require_login();
require_admin();

$pdo = get_pdo();
$msg=null;$err=null;

function gen_password($len=10){
    $chars = 'ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnpqrstuvwxyz23456789@#$%';
    $out=''; for($i=0;$i<$len;$i++){$out.=$chars[random_int(0,strlen($chars)-1)];}
    return $out;
}

if ($_SERVER['REQUEST_METHOD']==='POST') {
    if (!csrf_check($_POST['csrf'] ?? '')) {
        $err='Token inválido';
    } else {
        $email = trim($_POST['email'] ?? '');
        $name = trim($_POST['display_name'] ?? '');
        $code = trim($_POST['affiliate_code'] ?? '');
        $pct = floatval($_POST['commission_pct'] ?? '3');
        $active = isset($_POST['is_active']) ? 1 : 0;

        if ($email==='' || $name==='' || $code==='') $err='Preencha e-mail, nome e código.';
        else {
            $pass = gen_password();
            $hash = password_hash($pass, PASSWORD_DEFAULT);
            try{
                $st = $pdo->prepare("INSERT INTO users (email,password_hash,role,display_name,affiliate_code,default_commission_pct,is_active) 
                                     VALUES (?,?,?,?,?,?,?)");
                $st->execute([$email,$hash,'affiliate',$name,$code,$pct,$active]);
                $msg = 'Afiliado criado. Senha inicial: ' . htmlspecialchars($pass);
            } catch (Exception $e){
                $err='Erro: ' . $e->getMessage();
            }
        }
    }
}

$rows = $pdo->query("SELECT id,display_name,email,affiliate_code,default_commission_pct,is_active,created_at FROM users WHERE role='affiliate' ORDER BY created_at DESC")->fetchAll();
?>
<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8"/>
<meta name="viewport" content="width=device-width, initial-scale=1"/>
<title>Afiliados - <?php echo APP_NAME; ?></title>
<link rel="stylesheet" href="<?php echo BASE_URL; ?>../../assets/style.css"/>
</head>
<body>
<div class="container">
  <div class="nav">
    <a class="btn" href="<?php echo BASE_URL; ?>../dashboard.php">Dashboard</a>
    <a class="btn" href="<?php echo BASE_URL; ?>../orders_list.php">Pedidos</a>
    <a class="btn" href="<?php echo BASE_URL; ?>./">Admin</a>
    <a class="btn btn-secondary" href="<?php echo BASE_URL; ?>../logout.php">Sair</a>
  </div>
  <div class="card">
    <h1>Afiliados</h1>
    <?php if ($msg): ?><div class="alert alert-success"><?php echo $msg; ?></div><?php endif; ?>
    <?php if ($err): ?><div class="alert alert-error"><?php echo $err; ?></div><?php endif; ?>
    <h3>Novo afiliado</h3>
    <form method="post" class="row">
      <input type="hidden" name="csrf" value="<?php echo csrf_token(); ?>"/>
      <div class="col"><label>Nome</label><input name="display_name" required/></div>
      <div class="col"><label>E-mail</label><input type="email" name="email" required/></div>
      <div class="col"><label>Código</label><input name="affiliate_code" required placeholder="OFD-ANA01"/></div>
      <div class="col"><label>% Comissão</label><input type="number" step="0.01" name="commission_pct" value="3.00"/></div>
      <div class="col" style="align-self:flex-end">
        <label><input type="checkbox" name="is_active" checked/> Ativo</label>
      </div>
      <div class="col" style="align-self:flex-end">
        <button class="btn btn-primary">Criar afiliado</button>
      </div>
    </form>
  </div>

  <div class="card">
    <h3>Lista</h3>
    <table class="table">
      <thead><tr><th>Nome</th><th>E-mail</th><th>Código</th><th>%</th><th>Status</th><th>Criado em</th></tr></thead>
      <tbody>
        <?php foreach ($rows as $r): ?>
          <tr>
            <td><?php echo htmlspecialchars($r['display_name']); ?></td>
            <td><?php echo htmlspecialchars($r['email']); ?></td>
            <td><?php echo htmlspecialchars($r['affiliate_code']); ?></td>
            <td><?php echo number_format($r['default_commission_pct'],2,',','.'); ?></td>
            <td><?php echo $r['is_active']?'Ativo':'Inativo'; ?></td>
            <td><?php echo htmlspecialchars($r['created_at']); ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
</body>
</html>
