<?php
require_once __DIR__ . '/../app/config.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/csrf.php';
require_login();

$pdo = get_pdo();
$user = current_user();
$msg=null;$err=null;

if ($_SERVER['REQUEST_METHOD']==='POST') {
    if (!csrf_check($_POST['csrf'] ?? '')) {
        $err='Token inválido';
    } else {
        $name = trim($_POST['full_name'] ?? '');
        $whats = trim($_POST['whatsapp'] ?? '');
        $city = trim($_POST['city'] ?? '');
        if ($name==='') $err='Nome obrigatório';
        else {
            $st = $pdo->prepare("INSERT INTO clients (affiliate_id, full_name, whatsapp, city) VALUES (?,?,?,?)");
            $st->execute([$user['id'], $name, $whats, $city]);
            $msg='Cliente salvo';
        }
    }
}

if ($user['role']==='admin') {
    $st = $pdo->query("SELECT c.*, u.display_name AS afiliado FROM clients c JOIN users u ON u.id=c.affiliate_id ORDER BY c.created_at DESC LIMIT 200");
} else {
    $st = $pdo->prepare("SELECT * FROM clients WHERE affiliate_id=? ORDER BY created_at DESC LIMIT 200");
    $st->execute([$user['id']]);
}
$rows = $st->fetchAll();
?>
<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8"/>
<meta name="viewport" content="width=device-width, initial-scale=1"/>
<title>Clientes - <?php echo APP_NAME; ?></title>
<link rel="stylesheet" href="<?php echo BASE_URL; ?>../assets/style.css"/>
</head>
<body>
<div class="container">
  <div class="nav">
    <a class="btn" href="<?php echo BASE_URL; ?>dashboard.php">Dashboard</a>
    <a class="btn" href="<?php echo BASE_URL; ?>orders_list.php">Pedidos</a>
    <?php if ($user['role']==='admin'): ?><a class="btn" href="<?php echo BASE_URL; ?>admin/">Admin</a><?php endif; ?>
    <a class="btn btn-secondary" href="<?php echo BASE_URL; ?>logout.php">Sair</a>
  </div>
  <div class="card">
    <h1>Clientes</h1>
    <?php if ($msg): ?><div class="alert alert-success"><?php echo htmlspecialchars($msg); ?></div><?php endif; ?>
    <?php if ($err): ?><div class="alert alert-error"><?php echo htmlspecialchars($err); ?></div><?php endif; ?>
    <h3>Novo cliente</h3>
    <form method="post" class="row">
      <input type="hidden" name="csrf" value="<?php echo csrf_token(); ?>"/>
      <div class="col"><label>Nome</label><input name="full_name" required/></div>
      <div class="col"><label>WhatsApp</label><input name="whatsapp"/></div>
      <div class="col"><label>Cidade</label><input name="city"/></div>
      <div class="col" style="align-self:flex-end"><button class="btn btn-primary">Salvar</button></div>
    </form>
    <h3 style="margin-top:16px">Lista</h3>
    <table class="table">
      <thead><tr><th>Nome</th><th>WhatsApp</th><th>Cidade</th><th>Afiliado</th></tr></thead>
      <tbody>
        <?php foreach ($rows as $r): ?>
          <tr>
            <td><?php echo htmlspecialchars($r['full_name']); ?></td>
            <td><?php echo htmlspecialchars($r['whatsapp']); ?></td>
            <td><?php echo htmlspecialchars($r['city']); ?></td>
            <td><?php echo isset($r['afiliado']) ? htmlspecialchars($r['afiliado']) : '—'; ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
</body>
</html>
