<?php
require_once __DIR__ . '/../app/config.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/csrf.php';
require_login();

$pdo = get_pdo();
$user = current_user();

// Resumos simples
if ($user['role'] === 'admin') {
    $st = $pdo->query("SELECT 
        SUM(CASE WHEN status='PROPOSTA' THEN 1 ELSE 0 END) AS propostas,
        SUM(CASE WHEN status='FECHADO' THEN 1 ELSE 0 END) AS fechados,
        SUM(CASE WHEN status='CANCELADO' THEN 1 ELSE 0 END) AS cancelados,
        SUM(commission_value) AS com_total
        FROM orders");
} else {
    $st = $pdo->prepare("SELECT 
        SUM(CASE WHEN status='PROPOSTA' THEN 1 ELSE 0 END) AS propostas,
        SUM(CASE WHEN status='FECHADO' THEN 1 ELSE 0 END) AS fechados,
        SUM(CASE WHEN status='CANCELADO' THEN 1 ELSE 0 END) AS cancelados,
        SUM(commission_value) AS com_total
        FROM orders WHERE affiliate_id = ?");
    $st->execute([$user['id']]);
}
$sum = $st->fetch() ?: ['propostas'=>0,'fechados'=>0,'cancelados'=>0,'com_total'=>0];

?>
<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8"/>
<meta name="viewport" content="width=device-width, initial-scale=1"/>
<title>Painel - <?php echo APP_NAME; ?></title>
<link rel="stylesheet" href="<?php echo BASE_URL; ?>../assets/style.css"/>
</head>
<body>
<div class="container">
  <div class="nav">
    <a class="btn" href="<?php echo BASE_URL; ?>dashboard.php">Dashboard</a>
    <a class="btn" href="<?php echo BASE_URL; ?>orders_list.php">Pedidos</a>
    <a class="btn" href="<?php echo BASE_URL; ?>order_new.php">Novo Pedido</a>
    <a class="btn" href="<?php echo BASE_URL; ?>clients.php">Clientes</a>
    <?php if ($user['role']==='admin'): ?>
    <a class="btn" href="<?php echo BASE_URL; ?>admin/">Admin</a>
    <?php endif; ?>
    <a class="btn btn-secondary" href="<?php echo BASE_URL; ?>logout.php">Sair</a>
  </div>

  <div class="card">
    <h1>Olá, <?php echo htmlspecialchars($user['display_name']); ?> 👋</h1>
    <div class="row">
      <div class="col card"><h3>Propostas</h3><div class="badge"><?php echo intval($sum['propostas']??0); ?></div></div>
      <div class="col card"><h3>Fechados</h3><div class="badge"><?php echo intval($sum['fechados']??0); ?></div></div>
      <div class="col card"><h3>Cancelados</h3><div class="badge"><?php echo intval($sum['cancelados']??0); ?></div></div>
      <div class="col card"><h3>Comissão acumulada</h3><div class="badge">R$ <?php echo number_format(floatval($sum['com_total']??0),2,',','.'); ?></div></div>
    </div>
  </div>
</div>
</body>
</html>
