<?php
require_once __DIR__ . '/../app/config.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/csrf.php';

if (current_user()) {
    // Redireciona para o painel correto
    if (current_user()['role'] === 'admin') {
        header('Location: ' . BASE_URL . 'admin/'); exit;
    } else {
        header('Location: ' . BASE_URL . 'dashboard.php'); exit;
    }
}

$error = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!csrf_check($_POST['csrf'] ?? '')) {
        $error = 'Token inválido. Atualize a página.';
    } else {
        $email = trim($_POST['email'] ?? '');
        $password = trim($_POST['password'] ?? '');
        if (login_user($email, $password)) {
            if (current_user()['role'] === 'admin') {
                header('Location: ' . BASE_URL . 'admin/'); exit;
            } else {
                header('Location: ' . BASE_URL . 'dashboard.php'); exit;
            }
        } else {
            $error = 'Login inválido.';
        }
    }
}
?>
<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8"/>
<meta name="viewport" content="width=device-width, initial-scale=1"/>
<title>Login - <?php echo APP_NAME; ?></title>
<link rel="stylesheet" href="<?php echo BASE_URL; ?>../assets/style.css"/>
</head>
<body>
<div class="container">
  <div class="card">
    <h1><?php echo APP_NAME; ?> — Login</h1>
    <?php if (isset($_GET['auth'])): ?>
      <div class="alert alert-error">Faça login para continuar.</div>
    <?php endif; ?>
    <?php if ($error): ?>
      <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    <form method="post">
      <input type="hidden" name="csrf" value="<?php echo csrf_token(); ?>"/>
      <label>E-mail</label>
      <input type="email" name="email" required placeholder="voce@exemplo.com"/>
      <label>Senha</label>
      <input type="password" name="password" required placeholder="Sua senha"/>
      <div style="margin-top:12px">
        <button class="btn btn-primary" type="submit">Entrar</button>
      </div>
    </form>
    <div class="footer">© <?php echo date('Y'); ?> <?php echo APP_NAME; ?></div>
  </div>
</div>
</body>
</html>
