<?php
require_once __DIR__ . '/../app/config.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/csrf.php';
require_login();

$pdo = get_pdo();
$user = current_user();

$msg = null; $err = null;

if ($_SERVER['REQUEST_METHOD']==='POST') {
    if (!csrf_check($_POST['csrf'] ?? '')) {
        $err = 'Token inválido.';
    } else {
        $client_name = trim($_POST['client_name'] ?? '');
        $client_whatsapp = trim($_POST['client_whatsapp'] ?? '');
        $client_city = trim($_POST['client_city'] ?? '');
        $product_name = trim($_POST['product_name'] ?? '');
        $quantity = intval($_POST['quantity'] ?? '1');
        $unit_price = floatval($_POST['unit_price'] ?? '0');
        $discount_value = floatval($_POST['discount_value'] ?? '0');
        $payment_method = trim($_POST['payment_method'] ?? '');
        $utm_source = trim($_POST['utm_source'] ?? '');
        $utm_medium = trim($_POST['utm_medium'] ?? '');
        $utm_campaign = trim($_POST['utm_campaign'] ?? '');
        $utm_term = trim($_POST['utm_term'] ?? '');
        $utm_content = trim($_POST['utm_content'] ?? '');

        if ($client_name === '' || $product_name === '' || $unit_price <= 0) {
            $err = 'Preencha cliente, produto e valor.';
        } else {
            $pdo->beginTransaction();
            try {
                // cria/insere cliente
                $st = $pdo->prepare("INSERT INTO clients (affiliate_id, full_name, whatsapp, city) VALUES (?,?,?,?)");
                $st->execute([$user['id'], $client_name, $client_whatsapp, $client_city]);
                $client_id = $pdo->lastInsertId();

                $subtotal = $quantity * $unit_price;
                $total = max(0, $subtotal - $discount_value);
                $commission_pct = floatval($user['default_commission_pct']);

                $st = $pdo->prepare("INSERT INTO orders 
                    (affiliate_id, client_id, status, payment_method, subtotal, discount_value, total, commission_pct, commission_value, commission_status,
                     utm_source, utm_medium, utm_campaign, utm_term, utm_content, created_by)
                    VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                $st->execute([
                    $user['id'], $client_id, 'PROPOSTA', $payment_method, $subtotal, $discount_value, $total, 
                    $commission_pct, 0, 'PENDENTE',
                    $utm_source, $utm_medium, $utm_campaign, $utm_term, $utm_content, $user['id']
                ]);
                $order_id = $pdo->lastInsertId();

                $st = $pdo->prepare("INSERT INTO order_items (order_id, product_name, sku, quantity, unit_price, line_total) 
                                     VALUES (?,?,?,?,?,?)");
                $st->execute([$order_id, $product_name, null, $quantity, $unit_price, $subtotal]);

                $pdo->commit();
                $msg = 'Proposta criada com sucesso!';
            } catch (Exception $e) {
                $pdo->rollBack();
                $err = 'Erro ao salvar: ' . $e->getMessage();
            }
        }
    }
}
?>
<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8"/>
<meta name="viewport" content="width=device-width, initial-scale=1"/>
<title>Novo Pedido - <?php echo APP_NAME; ?></title>
<link rel="stylesheet" href="<?php echo BASE_URL; ?>../assets/style.css"/>
</head>
<body>
<div class="container">
  <div class="nav">
    <a class="btn" href="<?php echo BASE_URL; ?>dashboard.php">Dashboard</a>
    <a class="btn" href="<?php echo BASE_URL; ?>orders_list.php">Pedidos</a>
    <a class="btn btn-secondary" href="<?php echo BASE_URL; ?>logout.php">Sair</a>
  </div>
  <div class="card">
    <h1>Novo Pedido (Proposta)</h1>
    <?php if ($msg): ?><div class="alert alert-success"><?php echo htmlspecialchars($msg); ?></div><?php endif; ?>
    <?php if ($err): ?><div class="alert alert-error"><?php echo htmlspecialchars($err); ?></div><?php endif; ?>

    <form method="post">
      <input type="hidden" name="csrf" value="<?php echo csrf_token(); ?>"/>
      <div class="row">
        <div class="col">
          <h3>Cliente</h3>
          <label>Nome</label><input name="client_name" required />
          <label>WhatsApp</label><input name="client_whatsapp" placeholder="55DDDNUMERO"/>
          <label>Cidade</label><input name="client_city"/>
        </div>
        <div class="col">
          <h3>Produto</h3>
          <label>Produto</label><input name="product_name" required placeholder="Guarda-roupa Casal 6 portas"/>
          <label>Quantidade</label><input type="number" name="quantity" value="1" min="1" />
          <label>Preço unitário (R$)</label><input type="number" step="0.01" name="unit_price" required />
          <label>Desconto (R$)</label><input type="number" step="0.01" name="discount_value" value="0"/>
          <label>Forma de pagamento</label>
          <select name="payment_method">
            <option value="">A definir</option>
            <option>PIX</option>
            <option>Crédito</option>
            <option>Débito</option>
            <option>Dinheiro</option>
            <option>Pagaleve</option>
            <option>Boleto</option>
          </select>
        </div>
      </div>
      <h3>UTM (opcional)</h3>
      <div class="row">
        <div class="col"><label>utm_source</label><input name="utm_source"/></div>
        <div class="col"><label>utm_medium</label><input name="utm_medium"/></div>
        <div class="col"><label>utm_campaign</label><input name="utm_campaign"/></div>
      </div>
      <div class="row">
        <div class="col"><label>utm_term</label><input name="utm_term"/></div>
        <div class="col"><label>utm_content</label><input name="utm_content"/></div>
      </div>
      <div style="margin-top:12px">
        <button class="btn btn-primary" type="submit">Salvar proposta</button>
      </div>
    </form>
  </div>
</div>
</body>
</html>
