<?php
require_once __DIR__ . '/../app/config.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/csrf.php';
require_login();

$pdo = get_pdo();
$user = current_user();
$msg = null; $err = null;

// Fechar pedido (Cliente aceitou proposta)
if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['action'] ?? '') === 'fechar') {
    if (!csrf_check($_POST['csrf'] ?? '')) {
        $err = 'Token inválido.';
    } else {
        $order_id = intval($_POST['order_id'] ?? 0);
        try {
            // Busca pedido
            if ($user['role'] === 'admin') {
                $st = $pdo->prepare("SELECT * FROM orders WHERE id=?");
                $st->execute([$order_id]);
            } else {
                $st = $pdo->prepare("SELECT * FROM orders WHERE id=? AND affiliate_id=?");
                $st->execute([$order_id, $user['id']]);
            }
            $order = $st->fetch();
            if (!$order) throw new Exception('Pedido não encontrado.');

            $commission_value = floatval($order['total']) * floatval($order['commission_pct']) / 100.0;
            $st = $pdo->prepare("UPDATE orders SET status='FECHADO', accepted_at=NOW(), closed_at=NOW(), commission_value=? WHERE id=?");
            $st->execute([$commission_value, $order_id]);
            $msg = 'Pedido fechado com sucesso.';
        } catch (Exception $e) {
            $err = 'Erro ao fechar: ' . $e->getMessage();
        }
    }
}

// Listagem
if ($user['role'] === 'admin') {
    $st = $pdo->query("SELECT o.*, c.full_name, u.display_name AS afiliado
                       FROM orders o
                       JOIN clients c ON c.id=o.client_id
                       JOIN users u ON u.id=o.affiliate_id
                       ORDER BY o.created_at DESC LIMIT 200");
} else {
    $st = $pdo->prepare("SELECT o.*, c.full_name 
                         FROM orders o
                         JOIN clients c ON c.id=o.client_id
                         WHERE o.affiliate_id=?
                         ORDER BY o.created_at DESC LIMIT 200");
    $st->execute([$user['id']]);
}
$rows = $st->fetchAll();
?>
<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8"/>
<meta name="viewport" content="width=device-width, initial-scale=1"/>
<title>Pedidos - <?php echo APP_NAME; ?></title>
<link rel="stylesheet" href="<?php echo BASE_URL; ?>../assets/style.css"/>
</head>
<body>
<div class="container">
  <div class="nav">
    <a class="btn" href="<?php echo BASE_URL; ?>dashboard.php">Dashboard</a>
    <a class="btn" href="<?php echo BASE_URL; ?>order_new.php">Novo Pedido</a>
    <?php if ($user['role']==='admin'): ?><a class="btn" href="<?php echo BASE_URL; ?>admin/">Admin</a><?php endif; ?>
    <a class="btn btn-secondary" href="<?php echo BASE_URL; ?>logout.php">Sair</a>
  </div>
  <div class="card">
    <h1>Pedidos</h1>
    <?php if ($msg): ?><div class="alert alert-success"><?php echo htmlspecialchars($msg); ?></div><?php endif; ?>
    <?php if ($err): ?><div class="alert alert-error"><?php echo htmlspecialchars($err); ?></div><?php endif; ?>
    <table class="table">
      <thead><tr><th>ID</th><th>Cliente</th><th>Status</th><th>Total</th><th>Comissão</th><th>Ações</th></tr></thead>
      <tbody>
      <?php foreach ($rows as $r): ?>
        <tr>
          <td>#<?php echo intval($r['id']); ?></td>
          <td><?php echo htmlspecialchars($r['full_name']); ?><?php if(isset($r['afiliado'])) echo ' — <small>'.htmlspecialchars($r['afiliado']).'</small>'; ?></td>
          <td><span class="badge"><?php echo htmlspecialchars($r['status']); ?></span></td>
          <td>R$ <?php echo number_format($r['total'],2,',','.'); ?></td>
          <td>R$ <?php echo number_format($r['commission_value'],2,',','.'); ?></td>
          <td>
            <?php if ($r['status']==='PROPOSTA'): ?>
              <form method="post" style="display:inline">
                <input type="hidden" name="csrf" value="<?php echo csrf_token(); ?>"/>
                <input type="hidden" name="action" value="fechar"/>
                <input type="hidden" name="order_id" value="<?php echo intval($r['id']); ?>"/>
                <button class="btn btn-primary" style="background:#9a0808;border-color:#9a0808">Cliente aceitou proposta</button>
              </form>
            <?php else: ?>
              —
            <?php endif; ?>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
</body>
</html>
